package io.burkard.cdk.services.panorama

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPackageVersionProps {

  def apply(
    packageVersion: String,
    patchVersion: String,
    packageId: String,
    updatedLatestPatchVersion: Option[String] = None,
    markLatest: Option[Boolean] = None,
    ownerAccount: Option[String] = None
  ): software.amazon.awscdk.services.panorama.CfnPackageVersionProps =
    (new software.amazon.awscdk.services.panorama.CfnPackageVersionProps.Builder)
      .packageVersion(packageVersion)
      .patchVersion(patchVersion)
      .packageId(packageId)
      .updatedLatestPatchVersion(updatedLatestPatchVersion.orNull)
      .markLatest(markLatest.map(Boolean.box).orNull)
      .ownerAccount(ownerAccount.orNull)
      .build()
}
