package io.burkard.cdk.services.lightsail.cfnContainer

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HealthCheckConfigProperty {

  def apply(
    timeoutSeconds: Option[Number] = None,
    successCodes: Option[String] = None,
    path: Option[String] = None,
    healthyThreshold: Option[Number] = None,
    unhealthyThreshold: Option[Number] = None,
    intervalSeconds: Option[Number] = None
  ): software.amazon.awscdk.services.lightsail.CfnContainer.HealthCheckConfigProperty =
    (new software.amazon.awscdk.services.lightsail.CfnContainer.HealthCheckConfigProperty.Builder)
      .timeoutSeconds(timeoutSeconds.orNull)
      .successCodes(successCodes.orNull)
      .path(path.orNull)
      .healthyThreshold(healthyThreshold.orNull)
      .unhealthyThreshold(unhealthyThreshold.orNull)
      .intervalSeconds(intervalSeconds.orNull)
      .build()
}
