package io.burkard.cdk.services.iotwireless.cfnMulticastGroup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoRaWANProperty {

  def apply(
    rfRegion: String,
    dlClass: String,
    numberOfDevicesInGroup: Option[Number] = None,
    numberOfDevicesRequested: Option[Number] = None
  ): software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty =
    (new software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty.Builder)
      .rfRegion(rfRegion)
      .dlClass(dlClass)
      .numberOfDevicesInGroup(numberOfDevicesInGroup.orNull)
      .numberOfDevicesRequested(numberOfDevicesRequested.orNull)
      .build()
}
