package io.burkard.cdk.services.events.cfnConnection

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthParametersProperty {

  def apply(
    authorizationEndpoint: String,
    httpMethod: String,
    clientParameters: software.amazon.awscdk.services.events.CfnConnection.ClientParametersProperty,
    oAuthHttpParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty] = None
  ): software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty =
    (new software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty.Builder)
      .authorizationEndpoint(authorizationEndpoint)
      .httpMethod(httpMethod)
      .clientParameters(clientParameters)
      .oAuthHttpParameters(oAuthHttpParameters.orNull)
      .build()
}
