package io.burkard.cdk.services.events

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthAuthorizationProps {

  def apply(
    clientId: String,
    httpMethod: software.amazon.awscdk.services.events.HttpMethod,
    authorizationEndpoint: String,
    clientSecret: software.amazon.awscdk.SecretValue,
    headerParameters: Option[Map[String, _ <: software.amazon.awscdk.services.events.HttpParameter]] = None,
    queryStringParameters: Option[Map[String, _ <: software.amazon.awscdk.services.events.HttpParameter]] = None,
    bodyParameters: Option[Map[String, _ <: software.amazon.awscdk.services.events.HttpParameter]] = None
  ): software.amazon.awscdk.services.events.OAuthAuthorizationProps =
    (new software.amazon.awscdk.services.events.OAuthAuthorizationProps.Builder)
      .clientId(clientId)
      .httpMethod(httpMethod)
      .authorizationEndpoint(authorizationEndpoint)
      .clientSecret(clientSecret)
      .headerParameters(headerParameters.map(_.asJava).orNull)
      .queryStringParameters(queryStringParameters.map(_.asJava).orNull)
      .bodyParameters(bodyParameters.map(_.asJava).orNull)
      .build()
}
