package io.burkard.cdk.services.autoscalingplans.cfnScalingPlan

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScalingInstructionProperty {

  def apply(
    scalableDimension: String,
    resourceId: String,
    maxCapacity: Number,
    serviceNamespace: String,
    minCapacity: Number,
    targetTrackingConfigurations: List[_],
    scalingPolicyUpdateBehavior: Option[String] = None,
    predictiveScalingMaxCapacityBuffer: Option[Number] = None,
    customizedLoadMetricSpecification: Option[software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty] = None,
    scheduledActionBufferTime: Option[Number] = None,
    predictiveScalingMode: Option[String] = None,
    predefinedLoadMetricSpecification: Option[software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty] = None,
    disableDynamicScaling: Option[Boolean] = None,
    predictiveScalingMaxCapacityBehavior: Option[String] = None
  ): software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ScalingInstructionProperty =
    (new software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ScalingInstructionProperty.Builder)
      .scalableDimension(scalableDimension)
      .resourceId(resourceId)
      .maxCapacity(maxCapacity)
      .serviceNamespace(serviceNamespace)
      .minCapacity(minCapacity)
      .targetTrackingConfigurations(targetTrackingConfigurations.asJava)
      .scalingPolicyUpdateBehavior(scalingPolicyUpdateBehavior.orNull)
      .predictiveScalingMaxCapacityBuffer(predictiveScalingMaxCapacityBuffer.orNull)
      .customizedLoadMetricSpecification(customizedLoadMetricSpecification.orNull)
      .scheduledActionBufferTime(scheduledActionBufferTime.orNull)
      .predictiveScalingMode(predictiveScalingMode.orNull)
      .predefinedLoadMetricSpecification(predefinedLoadMetricSpecification.orNull)
      .disableDynamicScaling(disableDynamicScaling.map(Boolean.box).orNull)
      .predictiveScalingMaxCapacityBehavior(predictiveScalingMaxCapacityBehavior.orNull)
      .build()
}
