package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnModuleDefaultVersion {

  def apply(
    internalResourceId: String,
    moduleName: Option[String] = None,
    versionId: Option[String] = None,
    arn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.CfnModuleDefaultVersion =
    software.amazon.awscdk.CfnModuleDefaultVersion.Builder
      .create(stackCtx, internalResourceId)
      .moduleName(moduleName.orNull)
      .versionId(versionId.orNull)
      .arn(arn.orNull)
      .build()
}
