package io.burkard.cdk.services.secretsmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourcePolicy {

  def apply(
    internalResourceId: String,
    resourcePolicy: AnyRef,
    secretId: String,
    blockPublicPolicy: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.secretsmanager.CfnResourcePolicy =
    software.amazon.awscdk.services.secretsmanager.CfnResourcePolicy.Builder
      .create(stackCtx, internalResourceId)
      .resourcePolicy(resourcePolicy)
      .secretId(secretId)
      .blockPublicPolicy(blockPublicPolicy.map(Boolean.box).orNull)
      .build()
}
