package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSolutionProps {

  def apply(
    name: String,
    datasetGroupArn: String,
    eventType: Option[String] = None,
    recipeArn: Option[String] = None,
    performHpo: Option[Boolean] = None,
    performAutoMl: Option[Boolean] = None,
    solutionConfig: Option[software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty] = None
  ): software.amazon.awscdk.services.personalize.CfnSolutionProps =
    (new software.amazon.awscdk.services.personalize.CfnSolutionProps.Builder)
      .name(name)
      .datasetGroupArn(datasetGroupArn)
      .eventType(eventType.orNull)
      .recipeArn(recipeArn.orNull)
      .performHpo(performHpo.map(Boolean.box).orNull)
      .performAutoMl(performAutoMl.map(Boolean.box).orNull)
      .solutionConfig(solutionConfig.orNull)
      .build()
}
