package io.burkard.cdk.services.msk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBatchScramSecretProps {

  def apply(
    clusterArn: String,
    secretArnList: Option[List[String]] = None
  ): software.amazon.awscdk.services.msk.CfnBatchScramSecretProps =
    (new software.amazon.awscdk.services.msk.CfnBatchScramSecretProps.Builder)
      .clusterArn(clusterArn)
      .secretArnList(secretArnList.map(_.asJava).orNull)
      .build()
}
