package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnContainer {

  def apply(
    internalResourceId: String,
    scale: Number,
    serviceName: String,
    power: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    containerServiceDeployment: Option[software.amazon.awscdk.services.lightsail.CfnContainer.ContainerServiceDeploymentProperty] = None,
    publicDomainNames: Option[List[_]] = None,
    isDisabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lightsail.CfnContainer =
    software.amazon.awscdk.services.lightsail.CfnContainer.Builder
      .create(stackCtx, internalResourceId)
      .scale(scale)
      .serviceName(serviceName)
      .power(power)
      .tags(tags.map(_.asJava).orNull)
      .containerServiceDeployment(containerServiceDeployment.orNull)
      .publicDomainNames(publicDomainNames.map(_.asJava).orNull)
      .isDisabled(isDisabled.map(Boolean.box).orNull)
      .build()
}
