package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBot {

  def apply(
    internalResourceId: String,
    name: String,
    dataPrivacy: AnyRef,
    idleSessionTtlInSeconds: Number,
    roleArn: String,
    botTags: Option[List[_]] = None,
    autoBuildBotLocales: Option[Boolean] = None,
    botLocales: Option[List[_]] = None,
    description: Option[String] = None,
    testBotAliasTags: Option[List[_]] = None,
    testBotAliasSettings: Option[software.amazon.awscdk.services.lex.CfnBot.TestBotAliasSettingsProperty] = None,
    botFileS3Location: Option[software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lex.CfnBot =
    software.amazon.awscdk.services.lex.CfnBot.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .dataPrivacy(dataPrivacy)
      .idleSessionTtlInSeconds(idleSessionTtlInSeconds)
      .roleArn(roleArn)
      .botTags(botTags.map(_.asJava).orNull)
      .autoBuildBotLocales(autoBuildBotLocales.map(Boolean.box).orNull)
      .botLocales(botLocales.map(_.asJava).orNull)
      .description(description.orNull)
      .testBotAliasTags(testBotAliasTags.map(_.asJava).orNull)
      .testBotAliasSettings(testBotAliasSettings.orNull)
      .botFileS3Location(botFileS3Location.orNull)
      .build()
}
