package io.burkard.cdk.services.lakeformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourceProps {

  def apply(
    useServiceLinkedRole: Boolean,
    resourceArn: String,
    roleArn: Option[String] = None
  ): software.amazon.awscdk.services.lakeformation.CfnResourceProps =
    (new software.amazon.awscdk.services.lakeformation.CfnResourceProps.Builder)
      .useServiceLinkedRole(useServiceLinkedRole)
      .resourceArn(resourceArn)
      .roleArn(roleArn.orNull)
      .build()
}
