package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OpenIdConnectProviderProps {

  def apply(
    url: String,
    clientIds: Option[List[String]] = None,
    thumbprints: Option[List[String]] = None
  ): software.amazon.awscdk.services.iam.OpenIdConnectProviderProps =
    (new software.amazon.awscdk.services.iam.OpenIdConnectProviderProps.Builder)
      .url(url)
      .clientIds(clientIds.map(_.asJava).orNull)
      .thumbprints(thumbprints.map(_.asJava).orNull)
      .build()
}
