package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RuntimePlatform {

  def apply(
    operatingSystemFamily: Option[software.amazon.awscdk.services.ecs.OperatingSystemFamily] = None,
    cpuArchitecture: Option[software.amazon.awscdk.services.ecs.CpuArchitecture] = None
  ): software.amazon.awscdk.services.ecs.RuntimePlatform =
    (new software.amazon.awscdk.services.ecs.RuntimePlatform.Builder)
      .operatingSystemFamily(operatingSystemFamily.orNull)
      .cpuArchitecture(cpuArchitecture.orNull)
      .build()
}
