package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PortMapping {

  def apply(
    containerPort: Number,
    protocol: Option[software.amazon.awscdk.services.ecs.Protocol] = None,
    hostPort: Option[Number] = None
  ): software.amazon.awscdk.services.ecs.PortMapping =
    (new software.amazon.awscdk.services.ecs.PortMapping.Builder)
      .containerPort(containerPort)
      .protocol(protocol.orNull)
      .hostPort(hostPort.orNull)
      .build()
}
