package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LinuxParametersProps {

  def apply(
    sharedMemorySize: Option[Number] = None,
    initProcessEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.ecs.LinuxParametersProps =
    (new software.amazon.awscdk.services.ecs.LinuxParametersProps.Builder)
      .sharedMemorySize(sharedMemorySize.orNull)
      .initProcessEnabled(initProcessEnabled.map(Boolean.box).orNull)
      .build()
}
