package io.burkard.cdk.services.ec2

sealed abstract class ClientVpnSessionTimeout(val underlying: software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout)
  extends Product
    with Serializable

object ClientVpnSessionTimeout {
  implicit def toAws(value: ClientVpnSessionTimeout): software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout =
    Option(value).map(_.underlying).orNull

  case object EightHours
    extends ClientVpnSessionTimeout(software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout.EIGHT_HOURS)

  case object TenHours
    extends ClientVpnSessionTimeout(software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout.TEN_HOURS)

  case object TwelveHours
    extends ClientVpnSessionTimeout(software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout.TWELVE_HOURS)

  case object TwentyFourHours
    extends ClientVpnSessionTimeout(software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout.TWENTY_FOUR_HOURS)
}
