package io.burkard.cdk.services.databrew.cfnJob

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DatabaseOutputProperty {

  def apply(
    databaseOptions: software.amazon.awscdk.services.databrew.CfnJob.DatabaseTableOutputOptionsProperty,
    glueConnectionName: String,
    databaseOutputMode: Option[String] = None
  ): software.amazon.awscdk.services.databrew.CfnJob.DatabaseOutputProperty =
    (new software.amazon.awscdk.services.databrew.CfnJob.DatabaseOutputProperty.Builder)
      .databaseOptions(databaseOptions)
      .glueConnectionName(glueConnectionName)
      .databaseOutputMode(databaseOutputMode.orNull)
      .build()
}
