package io.burkard.cdk.services.connect.cfnUser

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserPhoneConfigProperty {

  def apply(
    phoneType: String,
    afterContactWorkTimeLimit: Option[Number] = None,
    autoAccept: Option[Boolean] = None,
    deskPhoneNumber: Option[String] = None
  ): software.amazon.awscdk.services.connect.CfnUser.UserPhoneConfigProperty =
    (new software.amazon.awscdk.services.connect.CfnUser.UserPhoneConfigProperty.Builder)
      .phoneType(phoneType)
      .afterContactWorkTimeLimit(afterContactWorkTimeLimit.orNull)
      .autoAccept(autoAccept.map(Boolean.box).orNull)
      .deskPhoneNumber(deskPhoneNumber.orNull)
      .build()
}
