package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthFlows {

  def apply(
    authorizationCodeGrant: Option[Boolean] = None,
    clientCredentials: Option[Boolean] = None,
    implicitCodeGrant: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.OAuthFlows =
    (new software.amazon.awscdk.services.cognito.OAuthFlows.Builder)
      .authorizationCodeGrant(authorizationCodeGrant.map(Boolean.box).orNull)
      .clientCredentials(clientCredentials.map(Boolean.box).orNull)
      .implicitCodeGrant(implicitCodeGrant.map(Boolean.box).orNull)
      .build()
}
