package io.burkard.cdk.services.codepipeline.actions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationDeployStackSetActionProps {

  def apply(
    stackSetName: String,
    template: software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate,
    maxAccountConcurrencyPercentage: Option[Number] = None,
    deploymentModel: Option[software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    description: Option[String] = None,
    stackSetRegion: Option[String] = None,
    variablesNamespace: Option[String] = None,
    stackInstances: Option[software.amazon.awscdk.services.codepipeline.actions.StackInstances] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    failureTolerancePercentage: Option[Number] = None,
    parameters: Option[software.amazon.awscdk.services.codepipeline.actions.StackSetParameters] = None,
    cfnCapabilities: Option[List[_ <: software.amazon.awscdk.CfnCapabilities]] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackSetActionProps =
    (new software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackSetActionProps.Builder)
      .stackSetName(stackSetName)
      .template(template)
      .maxAccountConcurrencyPercentage(maxAccountConcurrencyPercentage.orNull)
      .deploymentModel(deploymentModel.orNull)
      .role(role.orNull)
      .description(description.orNull)
      .stackSetRegion(stackSetRegion.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .stackInstances(stackInstances.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .failureTolerancePercentage(failureTolerancePercentage.orNull)
      .parameters(parameters.orNull)
      .cfnCapabilities(cfnCapabilities.map(_.asJava).orNull)
      .build()
}
