package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfigProps {

  def apply(
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None,
    deploymentConfigName: Option[String] = None,
    computePlatform: Option[String] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None
  ): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps =
    (new software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .computePlatform(computePlatform.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .build()
}
