package io.burkard.cdk.services.codecommit

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RepositoryNotifyOnOptions {

  def apply(
    events: List[_ <: software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents],
    enabled: Option[Boolean] = None,
    notificationRuleName: Option[String] = None,
    detailType: Option[software.amazon.awscdk.services.codestarnotifications.DetailType] = None
  ): software.amazon.awscdk.services.codecommit.RepositoryNotifyOnOptions =
    (new software.amazon.awscdk.services.codecommit.RepositoryNotifyOnOptions.Builder)
      .events(events.asJava)
      .enabled(enabled.map(Boolean.box).orNull)
      .notificationRuleName(notificationRuleName.orNull)
      .detailType(detailType.orNull)
      .build()
}
