package io.burkard.cdk.services.cloudwatch.actions

sealed abstract class OpsItemCategory(val underlying: software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory)
  extends Product
    with Serializable

object OpsItemCategory {
  implicit def toAws(value: OpsItemCategory): software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory =
    Option(value).map(_.underlying).orNull

  case object Availability
    extends OpsItemCategory(software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory.AVAILABILITY)

  case object Cost
    extends OpsItemCategory(software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory.COST)

  case object Performance
    extends OpsItemCategory(software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory.PERFORMANCE)

  case object Recovery
    extends OpsItemCategory(software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory.RECOVERY)

  case object Security
    extends OpsItemCategory(software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory.SECURITY)
}
