package io.burkard.cdk.services.cloudfront.cfnDistribution

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomErrorResponseProperty {

  def apply(
    errorCode: Number,
    errorCachingMinTtl: Option[Number] = None,
    responsePagePath: Option[String] = None,
    responseCode: Option[Number] = None
  ): software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomErrorResponseProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomErrorResponseProperty.Builder)
      .errorCode(errorCode)
      .errorCachingMinTtl(errorCachingMinTtl.orNull)
      .responsePagePath(responsePagePath.orNull)
      .responseCode(responseCode.orNull)
      .build()
}
