package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RouteProps {

  def apply(
    virtualRouter: software.amazon.awscdk.services.appmesh.IVirtualRouter,
    mesh: software.amazon.awscdk.services.appmesh.IMesh,
    routeName: Option[String] = None,
    routeSpec: Option[software.amazon.awscdk.services.appmesh.RouteSpec] = None
  ): software.amazon.awscdk.services.appmesh.RouteProps =
    (new software.amazon.awscdk.services.appmesh.RouteProps.Builder)
      .virtualRouter(virtualRouter)
      .mesh(mesh)
      .routeName(routeName.orNull)
      .routeSpec(routeSpec.orNull)
      .build()
}
