package io.burkard.cdk.services.ses.cfnTemplate

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TemplateProperty {

  def apply(
    subjectPart: String,
    htmlPart: Option[String] = None,
    templateName: Option[String] = None,
    textPart: Option[String] = None
  ): software.amazon.awscdk.services.ses.CfnTemplate.TemplateProperty =
    (new software.amazon.awscdk.services.ses.CfnTemplate.TemplateProperty.Builder)
      .subjectPart(subjectPart)
      .htmlPart(htmlPart.orNull)
      .templateName(templateName.orNull)
      .textPart(textPart.orNull)
      .build()
}
