package io.burkard.cdk.services.sagemaker.cfnMonitoringSchedule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClusterConfigProperty {

  def apply(
    instanceCount: Number,
    instanceType: String,
    volumeSizeInGb: Number,
    volumeKmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ClusterConfigProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ClusterConfigProperty.Builder)
      .instanceCount(instanceCount)
      .instanceType(instanceType)
      .volumeSizeInGb(volumeSizeInGb)
      .volumeKmsKeyId(volumeKmsKeyId.orNull)
      .build()
}
