package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAppProps {

  def apply(
    appType: String,
    appName: String,
    userProfileName: String,
    domainId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    resourceSpec: Option[software.amazon.awscdk.services.sagemaker.CfnApp.ResourceSpecProperty] = None
  ): software.amazon.awscdk.services.sagemaker.CfnAppProps =
    (new software.amazon.awscdk.services.sagemaker.CfnAppProps.Builder)
      .appType(appType)
      .appName(appName)
      .userProfileName(userProfileName)
      .domainId(domainId)
      .tags(tags.map(_.asJava).orNull)
      .resourceSpec(resourceSpec.orNull)
      .build()
}
