package io.burkard.cdk.services.managedblockchain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMember {

  def apply(
    internalResourceId: String,
    memberConfiguration: software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty,
    networkConfiguration: Option[software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty] = None,
    networkId: Option[String] = None,
    invitationId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.managedblockchain.CfnMember =
    software.amazon.awscdk.services.managedblockchain.CfnMember.Builder
      .create(stackCtx, internalResourceId)
      .memberConfiguration(memberConfiguration)
      .networkConfiguration(networkConfiguration.orNull)
      .networkId(networkId.orNull)
      .invitationId(invitationId.orNull)
      .build()
}
