package io.burkard.cdk.services.elasticache

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSecurityGroupIngressProps {

  def apply(
    cacheSecurityGroupName: String,
    ec2SecurityGroupName: String,
    ec2SecurityGroupOwnerId: Option[String] = None
  ): software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngressProps =
    (new software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngressProps.Builder)
      .cacheSecurityGroupName(cacheSecurityGroupName)
      .ec2SecurityGroupName(ec2SecurityGroupName)
      .ec2SecurityGroupOwnerId(ec2SecurityGroupOwnerId.orNull)
      .build()
}
