package io.burkard.cdk.services.elasticache

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSecurityGroupIngress {

  def apply(
    internalResourceId: String,
    cacheSecurityGroupName: String,
    ec2SecurityGroupName: String,
    ec2SecurityGroupOwnerId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress =
    software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress.Builder
      .create(stackCtx, internalResourceId)
      .cacheSecurityGroupName(cacheSecurityGroupName)
      .ec2SecurityGroupName(ec2SecurityGroupName)
      .ec2SecurityGroupOwnerId(ec2SecurityGroupOwnerId.orNull)
      .build()
}
