package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptionsBase {

  def apply(
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase =
    (new software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase.Builder)
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
