package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIPAMPool {

  def apply(
    internalResourceId: String,
    ipamScopeId: String,
    addressFamily: String,
    sourceIpamPoolId: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    allocationResourceTags: Option[List[_]] = None,
    locale: Option[String] = None,
    provisionedCidrs: Option[List[_]] = None,
    allocationDefaultNetmaskLength: Option[Number] = None,
    publiclyAdvertisable: Option[Boolean] = None,
    autoImport: Option[Boolean] = None,
    allocationMinNetmaskLength: Option[Number] = None,
    allocationMaxNetmaskLength: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnIPAMPool =
    software.amazon.awscdk.services.ec2.CfnIPAMPool.Builder
      .create(stackCtx, internalResourceId)
      .ipamScopeId(ipamScopeId)
      .addressFamily(addressFamily)
      .sourceIpamPoolId(sourceIpamPoolId.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .allocationResourceTags(allocationResourceTags.map(_.asJava).orNull)
      .locale(locale.orNull)
      .provisionedCidrs(provisionedCidrs.map(_.asJava).orNull)
      .allocationDefaultNetmaskLength(allocationDefaultNetmaskLength.orNull)
      .publiclyAdvertisable(publiclyAdvertisable.map(Boolean.box).orNull)
      .autoImport(autoImport.map(Boolean.box).orNull)
      .allocationMinNetmaskLength(allocationMinNetmaskLength.orNull)
      .allocationMaxNetmaskLength(allocationMaxNetmaskLength.orNull)
      .build()
}
