package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHostProps {

  def apply(
    instanceType: String,
    availabilityZone: String,
    autoPlacement: Option[String] = None,
    hostRecovery: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnHostProps =
    (new software.amazon.awscdk.services.ec2.CfnHostProps.Builder)
      .instanceType(instanceType)
      .availabilityZone(availabilityZone)
      .autoPlacement(autoPlacement.orNull)
      .hostRecovery(hostRecovery.orNull)
      .build()
}
