package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfig {

  def apply(
    internalResourceId: String,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None,
    deploymentConfigName: Option[String] = None,
    computePlatform: Option[String] = None,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig =
    software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.Builder
      .create(stackCtx, internalResourceId)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .computePlatform(computePlatform.orNull)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .build()
}
