package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudWatchLoggingOptions {

  def apply(
    prefix: Option[String] = None,
    enabled: Option[Boolean] = None,
    logGroup: Option[software.amazon.awscdk.services.logs.ILogGroup] = None
  ): software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions =
    (new software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions.Builder)
      .prefix(prefix.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .logGroup(logGroup.orNull)
      .build()
}
