package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FunctionProps {

  def apply(
    code: software.amazon.awscdk.services.cloudfront.FunctionCode,
    comment: Option[String] = None,
    functionName: Option[String] = None
  ): software.amazon.awscdk.services.cloudfront.FunctionProps =
    (new software.amazon.awscdk.services.cloudfront.FunctionProps.Builder)
      .code(code)
      .comment(comment.orNull)
      .functionName(functionName.orNull)
      .build()
}
