package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpIntegration {

  def apply(
    url: String,
    proxy: Option[Boolean] = None,
    options: Option[software.amazon.awscdk.services.apigateway.IntegrationOptions] = None,
    httpMethod: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.HttpIntegration =
    software.amazon.awscdk.services.apigateway.HttpIntegration.Builder
      .create(url)
      .proxy(proxy.map(Boolean.box).orNull)
      .options(options.orNull)
      .httpMethod(httpMethod.orNull)
      .build()
}
