package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BasePathMappingProps {

  def apply(
    restApi: software.amazon.awscdk.services.apigateway.IRestApi,
    domainName: software.amazon.awscdk.services.apigateway.IDomainName,
    stage: Option[software.amazon.awscdk.services.apigateway.Stage] = None,
    basePath: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.BasePathMappingProps =
    (new software.amazon.awscdk.services.apigateway.BasePathMappingProps.Builder)
      .restApi(restApi)
      .domainName(domainName)
      .stage(stage.orNull)
      .basePath(basePath.orNull)
      .build()
}
