package io.burkard.cdk.services.amazonmq.cfnBroker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LdapServerMetadataProperty {

  def apply(
    serviceAccountUsername: String,
    userBase: String,
    userSearchMatching: String,
    hosts: List[String],
    serviceAccountPassword: String,
    roleSearchMatching: String,
    roleBase: String,
    roleSearchSubtree: Option[Boolean] = None,
    roleName: Option[String] = None,
    userRoleName: Option[String] = None,
    userSearchSubtree: Option[Boolean] = None
  ): software.amazon.awscdk.services.amazonmq.CfnBroker.LdapServerMetadataProperty =
    (new software.amazon.awscdk.services.amazonmq.CfnBroker.LdapServerMetadataProperty.Builder)
      .serviceAccountUsername(serviceAccountUsername)
      .userBase(userBase)
      .userSearchMatching(userSearchMatching)
      .hosts(hosts.asJava)
      .serviceAccountPassword(serviceAccountPassword)
      .roleSearchMatching(roleSearchMatching)
      .roleBase(roleBase)
      .roleSearchSubtree(roleSearchSubtree.map(Boolean.box).orNull)
      .roleName(roleName.orNull)
      .userRoleName(userRoleName.orNull)
      .userSearchSubtree(userSearchSubtree.map(Boolean.box).orNull)
      .build()
}
