package io.burkard.cdk.services.waf.regional

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRateBasedRule {

  def apply(
    internalResourceId: String,
    name: String,
    metricName: String,
    rateLimit: Number,
    rateKey: String,
    matchPredicates: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.waf.regional.CfnRateBasedRule =
    software.amazon.awscdk.services.waf.regional.CfnRateBasedRule.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .metricName(metricName)
      .rateLimit(rateLimit)
      .rateKey(rateKey)
      .matchPredicates(matchPredicates.map(_.asJava).orNull)
      .build()
}
