package io.burkard.cdk.services.timestream

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnScheduledQueryProps {

  def apply(
    scheduledQueryExecutionRoleArn: String,
    queryString: String,
    scheduleConfiguration: software.amazon.awscdk.services.timestream.CfnScheduledQuery.ScheduleConfigurationProperty,
    notificationConfiguration: software.amazon.awscdk.services.timestream.CfnScheduledQuery.NotificationConfigurationProperty,
    errorReportConfiguration: software.amazon.awscdk.services.timestream.CfnScheduledQuery.ErrorReportConfigurationProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    clientToken: Option[String] = None,
    scheduledQueryName: Option[String] = None,
    targetConfiguration: Option[software.amazon.awscdk.services.timestream.CfnScheduledQuery.TargetConfigurationProperty] = None,
    kmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.timestream.CfnScheduledQueryProps =
    (new software.amazon.awscdk.services.timestream.CfnScheduledQueryProps.Builder)
      .scheduledQueryExecutionRoleArn(scheduledQueryExecutionRoleArn)
      .queryString(queryString)
      .scheduleConfiguration(scheduleConfiguration)
      .notificationConfiguration(notificationConfiguration)
      .errorReportConfiguration(errorReportConfiguration)
      .tags(tags.map(_.asJava).orNull)
      .clientToken(clientToken.orNull)
      .scheduledQueryName(scheduledQueryName.orNull)
      .targetConfiguration(targetConfiguration.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
