package io.burkard.cdk.services.signer

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SigningProfileProps {

  def apply(
    platform: software.amazon.awscdk.services.signer.Platform,
    signatureValidity: Option[software.amazon.awscdk.Duration] = None,
    signingProfileName: Option[String] = None
  ): software.amazon.awscdk.services.signer.SigningProfileProps =
    (new software.amazon.awscdk.services.signer.SigningProfileProps.Builder)
      .platform(platform)
      .signatureValidity(signatureValidity.orNull)
      .signingProfileName(signingProfileName.orNull)
      .build()
}
