package io.burkard.cdk.services.servicecatalog

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCloudFormationProduct {

  def apply(
    internalResourceId: String,
    name: String,
    provisioningArtifactParameters: List[_],
    owner: String,
    supportEmail: Option[String] = None,
    supportUrl: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    supportDescription: Option[String] = None,
    replaceProvisioningArtifacts: Option[Boolean] = None,
    acceptLanguage: Option[String] = None,
    distributor: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct =
    software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .provisioningArtifactParameters(provisioningArtifactParameters.asJava)
      .owner(owner)
      .supportEmail(supportEmail.orNull)
      .supportUrl(supportUrl.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .supportDescription(supportDescription.orNull)
      .replaceProvisioningArtifacts(replaceProvisioningArtifacts.map(Boolean.box).orNull)
      .acceptLanguage(acceptLanguage.orNull)
      .distributor(distributor.orNull)
      .build()
}
