package io.burkard.cdk.services.s3.cfnBucket

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricsConfigurationProperty {

  def apply(
    id: String,
    prefix: Option[String] = None,
    accessPointArn: Option[String] = None,
    tagFilters: Option[List[_]] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty.Builder)
      .id(id)
      .prefix(prefix.orNull)
      .accessPointArn(accessPointArn.orNull)
      .tagFilters(tagFilters.map(_.asJava).orNull)
      .build()
}
