package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BlockPublicAccess {

  def apply(
    ignorePublicAcls: Boolean,
    restrictPublicBuckets: Boolean,
    blockPublicAcls: Boolean,
    blockPublicPolicy: Boolean
  ): software.amazon.awscdk.services.s3.BlockPublicAccess =
    software.amazon.awscdk.services.s3.BlockPublicAccess.Builder
      .create()
      .ignorePublicAcls(ignorePublicAcls)
      .restrictPublicBuckets(restrictPublicBuckets)
      .blockPublicAcls(blockPublicAcls)
      .blockPublicPolicy(blockPublicPolicy)
      .build()
}
