package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRecordSetGroup {

  def apply(
    internalResourceId: String,
    comment: Option[String] = None,
    hostedZoneName: Option[String] = None,
    recordSets: Option[List[_]] = None,
    hostedZoneId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.CfnRecordSetGroup =
    software.amazon.awscdk.services.route53.CfnRecordSetGroup.Builder
      .create(stackCtx, internalResourceId)
      .comment(comment.orNull)
      .hostedZoneName(hostedZoneName.orNull)
      .recordSets(recordSets.map(_.asJava).orNull)
      .hostedZoneId(hostedZoneId.orNull)
      .build()
}
