package io.burkard.cdk.services.rekognition

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCollectionProps {

  def apply(
    collectionId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.rekognition.CfnCollectionProps =
    (new software.amazon.awscdk.services.rekognition.CfnCollectionProps.Builder)
      .collectionId(collectionId)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
